"""PyRTF3 - Rich Text Format Document Generation For Python 3

PyRTF3 is a Python 3 port of PyRTF, a pure python module for the efficient
generation of rich text format documents. Supports styles, tables, cell
merging, jpg and png images, Unicode, and tries to maintain compatibility
with as many RTF readers as possible.
PyRTF was originally written by Simon Cusack."""

classifiers = """\
Development Status :: 4 - Beta
Topic :: Text Editors :: Text Processing
Topic :: Software Development :: Libraries :: Python Modules
Intended Audience :: Developers
Programming Language :: Python
License :: OSI Approved :: GNU General Public License (GPL)
License :: OSI Approved :: GNU Library or Lesser General Public License (LGPL)
"""

import	sys
from distutils.core import setup

doclines = __doc__.split("\n")

setup( name		= 'PyRTF3',
       version	        = '0.1.0',
       author           = 'Michael Casolary',
       author_email     = 'michael@gigabytemike.com',
       url              = 'http://www.gigabytemike.com/pyrtf.html',
       license	        = 'http://www.gnu.org/licenses/gpl.html',
       platforms	= [ 'Any' ],
       description	= doclines[0],
       classifiers	= filter( None, classifiers.split( '\n' ) ),
       long_description = '\n'.join( doclines[2:] ),
       keywords         = ( 'RTF',
                            'Rich Text',
                            'Rich Text Format',
                            'documentation',
                            'reports' ),
       packages         = [ 'PyRTF3', ],
       package_dir      = { '' : '.' },
       requires         = [ 'rtfunicode' ],
       data_files       = [ ('PyRTF3_examples', ['examples/examples.py', 'examples/Examples1_1.rtf', 'examples/Examples1_2.rtf', 'examples/Examples1_3.rtf', 'examples/Examples1_4.rtf', 'examples/Examples1_5.rtf', 'examples/Examples1_6.rtf', 'examples/Examples1_7.rtf', 'examples/examples2.py', 'examples/Examples2_1.rtf', 'examples/image.jpg', 'examples/image_tmp.py', 'examples/img1.png', 'examples/img2.png', 'examples/img3.png', 'examples/img4.png', 'examples/merged_cells.py', 'examples/MergedCells.rtf']) ]
       )
